<?php
class WP_Travel_Downloads_Ajax{
    public static function init(){
        add_action( 'wp_ajax_wp_travel_get_downloads', array( __CLASS__, 'get_downloads' ) );
        add_action( 'wp_ajax_nopriv_wp_travel_get_downloads', array( __CLASS__, 'get_downloads' ) );

        add_action( 'wp_ajax_wp_travel_get_downloads_by_trip_id', array( __CLASS__, 'get_downloads_by_trip_id' ) );
        add_action( 'wp_ajax_nopriv_wp_travel_get_downloads_by_trip_id', array( __CLASS__, 'get_downloads_by_trip_id' ) );
    }

    public static function get_downloads(){
        $nonce = $_REQUEST['_nonce'];
        if( ! wp_verify_nonce( $nonce, 'wp_travel_nonce' )){
            $error = WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_INVALID_NONCE' );
            WP_Travel_Helpers_REST_API::response( $error );
        }
        $args = array();
        if ( ! empty( $_GET['keyword'] ) ) {
            $args['s'] = esc_attr( $_GET['keyword'] );
        }
        $response = WP_Travel_Downloads_Helpers_Downloads::get_downloads( $args );
        WP_Travel_Helpers_REST_API::response( $response );
    }

    public static function get_downloads_by_trip_id() {
        $nonce = $_REQUEST['_nonce'];
        if( ! wp_verify_nonce( $nonce, 'wp_travel_nonce' )){
            $error = WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_INVALID_NONCE' );
            WP_Travel_Helpers_REST_API::response( $error );
        }

        if ( empty( $_GET['trip_id'] ) ) {
			return WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_NO_TRIP_ID' );
        }
        
        $trip_id = absint( $_GET['trip_id'] );
        $response = WP_Travel_Downloads_Helpers_Downloads::get_downloads_by_trip_id( $trip_id );
        WP_Travel_Helpers_REST_API::response( $response );
    }
}

WP_Travel_Downloads_Ajax::init();