<?php
class WP_Travel_Downloads_Actions_Trips {
	public static function init() {
		add_action( 'wp_travel_update_trip_data', array( __CLASS__, 'update_trip_downloads' ), 10, 2 );
		add_filter( 'wp_travel_trip_data', array( __CLASS__, 'set_trip_download_data' ), 10, 2 );
	}

	public static function update_trip_downloads( $trip_data, $trip_id ) {
        /**
		 * @since 5.6
		 * Set trip setting for sending mail with attached itinerary pdf
		 */
		$send_itinerary_pdf = isset( $trip_data->send_itinerary_pdf ) ? $trip_data->send_itinerary_pdf : false;
		update_post_meta( $trip_id, 'send_booking_maile_attached_itinerary_pdf', $send_itinerary_pdf );

		$trip_data          = (array) $trip_data;
		$previous_downloads = get_post_meta( $trip_id, 'wp_travel_downloads', true );
		$previous_downloads = false == $previous_downloads ? array() : (array) $previous_downloads;
		if ( isset( $trip_data['downloads'] ) ) {
			$downloads = array();
			if ( ! empty( $trip_data['downloads'] ) ) {
				foreach ( $trip_data['downloads'] as $download ) {
					$download = (array) $download;
					if ( ! in_array( $download['id'], $downloads ) ) {
						$downloads[] = $download['id'];
					}
				}
			}

			$previous_downloads['downloads'] = $downloads;
		}

		if ( isset( $trip_data['email_downloads'] ) ) {
			// ws_error_log( $trip_data['email_downloads'] );
			$downloads = array();
			if ( ! empty( $trip_data['email_downloads'] ) ) {
				foreach ( $trip_data['email_downloads'] as $download ) {
					$download = (array) $download;
					if ( ! in_array( $download['id'], $downloads ) ) {
						$downloads[] = $download['id'];
					}
				}
			}

			$previous_downloads['email_downloads'] = $downloads;
		}

		update_post_meta( $trip_id, 'wp_travel_downloads', $previous_downloads );

		if ( isset( $trip_data['itinerary_downloads'] ) ) {
			update_post_meta( $trip_id, 'itinerary_downloads', $trip_data['itinerary_downloads'] );
		}
		
	}


	public static function set_trip_download_data( $trip_data, $trip_id ) {
		$downloads                    = WP_Travel_Downloads_Helpers_Downloads::get_downloads_by_trip_id( $trip_id );
		$trip_data['downloads']       = array();
		$trip_data['email_downloads'] = array();
		if ( ! is_wp_error( $downloads ) && 'WP_TRAVEL_TRIP_DOWNLOADS_DATA' === $downloads['code'] ) {
			$trip_data['downloads']           = $downloads['downloads']['downloads'];
			$trip_data['email_downloads']     = $downloads['downloads']['email_downloads'];
			$trip_data['itinerary_downloads'] = get_post_meta( $trip_id, 'itinerary_downloads', true );

		}
        /**
         * @since 5.6
         * Get trip setting for sending mail with attached itinerary pdf
         */
        $send_itinerary_pdf = get_post_meta( $trip_id, 'send_booking_maile_attached_itinerary_pdf', true );
        $trip_data['send_itinerary_pdf'] = $send_itinerary_pdf;
		return $trip_data;
	}


}

WP_Travel_Downloads_Actions_Trips::init();
