<?php
class WP_Travel_Downloads_Actions_Response_Codes {
    public static function init() {
        add_action( 'wp_travel_error_codes', array( __CLASS__, 'add_error_codes' ) );
        add_action( 'wp_travel_success_codes', array( __CLASS__, 'add_success_codes' ) );
    }

    public static function add_error_codes( $error_codes ) {
        $error_codes['WP_TRAVEL_NO_DOWNLOADS_FOUND']  = array(
            'message' => __( 'Downloads not found.', 'wp-travel-pro' ),
        );

        return $error_codes;
    }

    public static function add_success_codes( $codes ) {
        $codes['WP_TRAVEL_DOWNLOADS_DATA']  = array(
            'message' => __( 'Downloads data found.', 'wp-travel-pro' ),
        );

        $codes['WP_TRAVEL_TRIP_DOWNLOADS_DATA']  = array(
            'message' => __( 'Trip downloads data found.', 'wp-travel-pro' ),
        );

        return $codes;
    }
}

WP_Travel_Downloads_Actions_Response_Codes::init();