<?php
class WP_Travel_Downloads_Actions_Register_Post_Types {
	public static function init() {
		$priority = 10;
		if ( function_exists( 'wptravel_get_submenu' ) ) {
			$sbumenus = wptravel_get_submenu();
			$priority = isset( $sbumenus['bookings']['downloads']['priority'] ) ? $sbumenus['bookings']['downloads']['priority'] : $priority;
		}
		add_action( 'init', array( __CLASS__, 'register_post_type' ), $priority );
		add_filter( 'post_updated_messages', array( __CLASS__, 'add_download_edit_update_messages' ) );
		// add_filter( 'views_edit-wp_travel_downloads', array( __CLASS__, 'display_download_list_notice' ) );
	}

	/**
	 * Registers the custom post type Downloads
	 */
	public static function register_post_type() {

		$labels   = array(
			'name'                  => __( 'Downloads', 'wp-travel-pro' ),
			'singular_name'         => __( 'Download', 'wp-travel-pro' ),
			'add_new'               => __( 'Add New download', 'wp-travel-pro' ),
			'add_new_item'          => __( 'Add New download', 'wp-travel-pro' ),
			'edit_item'             => __( 'Edit download', 'wp-travel-pro' ),
			'new_item'              => __( 'Add New download', 'wp-travel-pro' ),
			'search_items'          => __( 'Search download', 'wp-travel-pro' ),
			'not_found'             => __( 'No downloads found', 'wp-travel-pro' ),
			'not_found_in_trash'    => __( 'No downloads found in trash', 'wp-travel-pro' ),
			'featured_image'        => __( 'Downloads Preview', 'wp-travel-pro' ),
			'set_featured_image'    => __( 'Set Downloads Preview', 'wp-travel-pro' ),
			'remove_featured_image' => __( 'Remove Downloads Preview', 'wp-travel-pro' ),
			'use_featured_image'    => __( 'Use Downloads Preview', 'wp-travel-pro' ),
		);
		$supports = array(
			'title',
			'thumbnail',
		);
		$args     = array(
			'labels'          => $labels,
			'supports'        => $supports,
			'public'          => true,
			'capability_type' => 'post',
			'rewrite'         => array( 'slug' => 'wp_travel_downloads' ),
			'has_archive'     => true,
			'description'     => __( 'If you delete a post from here, please update your <a href="/wp-admin/edit.php?post_type=itineraries" target="_blank">Trips</a> to make changes.', 'wp-travel-pro' ),
			'menu_position'   => 30,
			'menu_icon'       => 'dashicons-download',
			'show_in_menu'    => 'edit.php?post_type=itinerary-booking', // Displays this cpt under "WP-Travel" as Downloads.
			// 'register_meta_box_cb' => 'wp_travel_downloads_add_download_metabox',
		);
		register_post_type( 'wp_travel_downloads', $args );
	}

	/**
	 * Removes links and customize text from "Post Update" messsages
	 */
	public static function add_download_edit_update_messages( $messages ) {
		global $post, $post_ID;

		$post_types = get_post_types(
			array(
				'show_ui'  => true,
				'_builtin' => false,
			),
			'objects'
		);

		$post_type = 'wp_travel_downloads';
		foreach ( $post_types as $post_object ) {

			$messages[ $post_type ] = array(

				0  => '', // Unused. Messages start at index 1.
				1  => esc_html( $post_object->labels->singular_name ) . __( ' updated.', 'wp-travel-pro' ),
				2  => __( 'Updated.', 'wp-travel-pro' ),
				3  => __( 'Deleted.', 'wp-travel-pro' ),
				4  => esc_html( $post_object->labels->singular_name ) . __( ' updated.', 'wp-travel-pro' ),
				5  => isset( $_GET['revision'] ) ? esc_html( $post_object->labels->singular_name ) . __( ' restored to revision from ', 'wp-travel-pro' ). esc_html( wp_post_revision_title( (int) $_GET['revision'], false ) )  : false,
				6  => esc_html( $post_object->labels->singular_name ) . __( ' added.', 'wp-travel-pro' ),
				7  => esc_html( $post_object->labels->singular_name ) . __( ' saved.', 'wp-travel-pro' ),
				8  => esc_html( $post_object->labels->singular_name ) . __( ' submitted.', 'wp-travel-pro' ),
				9  => esc_html( $post_object->labels->singular_name ) . __( ' scheduled for: ', 'wp-travel-pro' ) . '<strong>'.date_i18n( __( 'M j, Y @ G:i', 'wp-travel-pro' ), strtotime( $post->post_date ) ).'</strong>.' ,
				10 => esc_html( $post_object->labels->singular_name ) . __( ' draft updated.', 'wp-travel-pro' ),

			);
		}
		return $messages;

	}

	/**
	 * Function to display description above downloads lists.
	 */
	public static function display_download_list_notice( $views ) {
		$screen    = get_current_screen();
		$post_type = get_post_type_object( $screen->post_type );
		$notice    = $post_type->description;
		if ( $notice ) {
			echo wp_kses_post( '<div class="notice notice-info is-dismissible"><p><strong>' . $notice . '</strong></p></div>' ); // Echo description.
		}
		return $views; // return original input unchanged.
	}
}

WP_Travel_Downloads_Actions_Register_Post_Types::init();
