<div class="wrap">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'Custom Filters', 'wp-travel-pro' ); ?></h1>
	<div id="col-container" class="wp-clearfix">
		<div id="col-left">
			<div class="col-wrap">
				<div class="form-wrap">
					<h2><?php esc_htmL_e( 'Add New Filter', 'wp-travel-pro' ); ?></h2>
					<form class="wp_travel_trip_filter-add-filter-form" method="GET" id="wp-travel-custom-filters-form">
						<input type="hidden" name="post_type" value="<?php echo esc_attr( 'itinerary-booking' ); ?>" />
						<input type="hidden" name="page" value="wp_travel_custom_filters_page" />

						<div class="form-field form-required term-name-wrap">
							<label><?php esc_html_e( 'Custom Filter Label :', 'wp-travel-pro' ); ?></label>
							<input type="text" name="label" value="" required="true"/>
						</div>
						<div class="form-field form-required term-name-wrap">
							<label><?php esc_html_e( 'Custom Filter Slug :', 'wp-travel-pro' ); ?></label>
							<input type="text" name="slug" value="" />
							<p>
								<?php esc_html_e( 'The “slug” is the URL-friendly version of the name. It is usually all lowercase and contains only letters, numbers, and hyphens.', 'wp-travel-pro' ); ?>
							</p>
						</div>
						<div class="form-field form-required term-name-wrap">
							<label><?php esc_html_e( 'Custom Filter Hierarchical :', 'wp-travel-pro' ); ?></label>
							<input type="checkbox" name="hierarchical" checked />
							<p>
								<?php esc_html_e( 'Enable this option to make custom filter behave like "post category". Otherwise, it will be similar to "post tag"', 'wp-travel-pro' ); ?>
							</p>
						</div>
						<div class="form-field form-required term-name-wrap">
							<label><?php esc_html_e( 'Show Admin Column :', 'wp-travel-pro' ); ?></label>
							<input type="checkbox" name="show_admin_column" />
							<p>
								<?php esc_html_e( 'Whether to allow automatic creation of taxonomy columns on Trips table. ', 'wp-travel-pro' ); ?>
							</p>
						</div>
						<div class="wp_travel_trip_filter-add-filter-form-submit">
							<input class="button button-primary" type="submit" value="<?php esc_html_e( 'Add New Custom Filter', 'wp-travel-pro' ); ?>" />
						</div>
					</form>
				</div>
			</div>
		</div>
		<div id="col-right">
			<div class="col-wrap">
				<?php $this->get_filters_listing_table(); ?>
			</div>
		</div>
	</div>
</div>
