<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Currency_Exchange_Rates_Core' ) ) :
	class WP_Travel_Currency_Exchange_Rates_Core {

		const WP_TRAVEL_CURRENCY_EXCHANGE_RATES_HANDLE = 'wp_travel_currency_exchange_rates_';

		protected static $ABSPATH;

		protected static $PLUGIN_FILE;

		protected static $VERSION;

			/**
			 * The single instance of the class.
			 *
			 * @var WP Travel Field Editor Core
			 * @since 1.0.0
			 */
		protected static $_instance = null;

			/**
			 * Main WP_Travel_Currency_Exchange_Rates_Core Instance.
			 * Ensures only one instance of WP_Travel_Currency_Exchange_Rates_Core is loaded or can be loaded.
			 *
			 * @since 1.0.0
			 * @static
			 * @see WP_Travel_Currency_Exchange_Rates_Core()
			 * @return WP_Travel_Currency_Exchange_Rates_Core - Main instance.
			 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Init core.
		 */
		public static function init() {
			self::$ABSPATH     = dirname( __FILE__ ) . '/';
			self::$PLUGIN_FILE = __FILE__;
			self::$VERSION     = '1.0.0';

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$enable_currency_exchange = isset( $settings['show_wp_travel_currency_exchange_rates'] ) ? $settings['show_wp_travel_currency_exchange_rates'] : 'yes';

			add_filter( 'wp_travel_settings_fields', array( 'WP_Travel_Currency_Exchange_Rates_Core', 'settings_fields' ) );
			add_action( 'wp_travel_addons_setings_tab_fields', array( 'WP_Travel_Currency_Exchange_Rates_Core', 'plugin_action' ) );
			add_action( 'admin_enqueue_scripts', array( 'WP_Travel_Currency_Exchange_Rates_Core', 'wp_travel_currency_exchange_rates_admin_styles' ) );
			// if ( 'yes' !== $enable_currency_exchange ) {
			// return;
			// }

			add_action( 'wp_enqueue_scripts', array( 'WP_Travel_Currency_Exchange_Rates_Core', 'wp_travel_currency_exchange_rates_frontend_styles' ) );

			/**
			 * @since 3.0.1
			 * @since wp-travel@4.0.4
			 */
			add_action( 'wp_head', array( __CLASS__, 'inline_style' ) );

			self::wp_travel_currency_exchange_rates_required_files();

		}

		/**
		 * Inline small snippet.
		 *
		 * @since 3.0.1
		 */
		public static function inline_style() {
			?>
			<style>
				.div_wp_travel_currency_exchange_rates_shortcode table tr:nth-child(even) {
					background: #e8e8e8;
				}

				#wp_travel_currency_exchange_rates_id-4 table tr:nth-child(even) {
					background: #444;
				}
			</style>
			<?php
		}

		/**
		 * Default settings fields.
		 *
		 * @param array $settings WP Travel Settings.
		 * @return array
		 */
		public static function settings_fields( $settings ) {
			$settings['show_wp_travel_currency_exchange_rates'] = 'yes';
			return $settings;
		}

		/**
		 * Plugin action to show / hide plugin settings and features.
		 */
		public static function plugin_action() {
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$field_name  = 'show_wp_travel_currency_exchange_rates';
			$field_label = __( 'WP Travel Currency Exchange Rates', 'wp-travel-pro' );

			$field_value = isset( $settings[ $field_name ] ) ? $settings[ $field_name ] : 'yes';
			?>
			<table class="form-table">
				<tr>
					<th>
						<label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html( $field_label ); ?></label>
					</th>
					<td>
						<span class="show-in-frontend checkbox-default-design">
							<label data-on="ON" data-off="OFF">
								<input value="no" name="<?php echo esc_attr( $field_name ); ?>" type="hidden" />
								<input <?php checked( $field_value, 'yes' ); ?> value="yes" name="<?php echo esc_attr( $field_name ); ?>" id="<?php echo esc_attr( $field_name ); ?>" type="checkbox" />
								<span class="switch"></span>
							</label>
						</span>
						<p class="description"><label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html__( 'Show all your "', 'wp-travel-pro' ) . esc_html( $field_label ) . esc_html__( '" settings and enable its feature.', 'wp-travel-pro' ); ?></label></p>
					</td>
				</tr>
			</table>
			<?php

		}

		/**
		 * Enqueue style and scripts for admin panel.
		 */
		public static function wp_travel_currency_exchange_rates_admin_styles() {

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}
			$screen = get_current_screen();
			if ( method_exists( 'WP_Travel', 'is_page' ) ) { // @since WP Travel 4.4.2
				$is_settings_page = WP_Travel::is_page( 'settings', true );
			} else {
				$is_settings_page = 'itinerary-booking_page_settings' == $screen->id;
			}
			if ( $is_settings_page ) {
				$deps                   = include_once sprintf( '%s/app/build/wp-travel-settings.asset.php', plugin_dir_path( __FILE__ ) );
				$deps['dependencies'][] = 'jquery';
				wp_enqueue_script( self::WP_TRAVEL_CURRENCY_EXCHANGE_RATES_HANDLE . 'admin-settings', plugin_dir_url( __FILE__ ) . '/app/build/wp-travel-settings.js', $deps['dependencies'], $deps['version'], true );
			}

			// Select2-css
			wp_enqueue_style( 'select2-style' );

			// Styles.
			// wp_enqueue_style( 'wp_travel_currency_exchange_rates_admin_styles', plugin_dir_url( __FILE__ ) . 'assets/admin-styles.css', array(), '1.0.0' );

			// Select2-js
			wp_enqueue_script( 'select2-js' );

			// Scripts.
			wp_enqueue_script( 'wp_travel_currency_exchange_rates_admin_scripts', plugin_dir_url( __FILE__ ) . 'assets/admin-scripts.js', array( 'jquery-ui-accordion' ), '1.0.0', true );

		}



		/**
		 * Enqueues our external stylesheet for frontend
		 */
		public static function wp_travel_currency_exchange_rates_frontend_styles() {
			// Styles.
			// Inlined @since wptravel@4.0.4
			// wp_enqueue_style( 'wp_travel_currency_exchange_rates_frontend_styles', plugin_dir_url( __FILE__ ) . 'assets/style.css', array(), '1.0.0' );

			// Scripts.
			// Don't enqueue empty script file.
			// wp_enqueue_script( 'wp_travel_currency_exchange_rates_frontend_scripts', plugin_dir_url( __FILE__ ) . 'assets/scripts.js', array(), '1.0.0', true );
		}

		/**
		 * Function to include files after plugin loaded.
		 */
		public static function wp_travel_currency_exchange_rates_required_files() {

			include_once self::$ABSPATH . '/inc/admin-settings-misc-api-key.php';
			include_once self::$ABSPATH . '/inc/templates.php';
			include_once self::$ABSPATH . '/inc/shortcodes.php';
			include_once self::$ABSPATH . '/inc/widgets.php';
			include_once self::$ABSPATH . '/inc/functions.php';

		}
	}
endif;

