<?php
/**
 * ============================================
 * Adds WP_Travel_Currency_Exchange_Rate widget.
 * ============================================
 */
class WP_Travel_Currency_Exchange_Rate extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'wp_travel_currency_exchange_rates_id', // Base ID
			esc_html__( 'WP Travel Currency Exchange Rates (Deprecated)', 'wp-travel-pro' ), // Name
			array( 'description' => esc_html__( 'WP Travel Currency Exchange Rates', 'wp-travel-pro' ) ) // Args
		);
	}

	/**
	 * ============================
	 * Frontend Display of widgets.
	 * ============================
	 */
	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$title               = ! empty( $instance['title'] ) ? ( $instance['title'] ) : 'Exchange Rates';
		$selected_currencies = ! empty( $instance['wp_travel_currency_exchange_rates_symbols'] ) ? $instance['wp_travel_currency_exchange_rates_symbols'] : '';

		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $title ) . $args['after_title'];
			echo wp_travel_currency_exchange_rates_frontend_templates( $selected_currencies );
		}
		echo $args['after_widget'];
	}
	/**
	 * ==============================
	 * /Frontend Display of widgets.
	 * ==============================
	 */

	/**
	 * ==============================
	 * Backend Display of widgets.
	 * ==============================
	 */
	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$symbols             = '';
		$selected_currencies = '';
		$selected            = '';
		$show                = '';
		$new_symbols         = '';
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		$get_currencies_array = wp_travel_currency_exchange_rates_currencies_name();
		$api_key              = $settings['exchange_rate_api_key'];
		$is_premium           = $settings['exchange_rate_api_key_premium_checkbox'];
		$title                = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Exchange Rates', 'wp-travel-pro' );
		$date                 = ! empty( $instance['date'] ) ? $instance['date'] : '';
		$instance_wp_travel_currency_exchange_rates_symbols = isset( $instance['wp_travel_currency_exchange_rates_symbols'] ) ? $instance['wp_travel_currency_exchange_rates_symbols'] : '';
		$exchange_rates                                     = wp_travel_currency_exchange_rates_transient_api_data( $selected_currencies );
		// error_log( print_r( $exchange_rates, true ) );

		$subscription_error = '';
		if ( ! empty( $exchange_rates['error']['info'] ) ) {
			// Outputs error msg if key is not premium.
			$subscription_error = $exchange_rates['error']['info'];
		}
		?>
		<p> 
			<?php echo __( 'This widget will be removed from v9.0.0. Please use "[wp_travel_currency_exchange_rates]" shortcode in replace of this widget.', 'wp-travel-pro' ); ?>
		</p>
		<?php

		if ( is_array( $exchange_rates ) || is_object( $exchange_rates ) && count( $exchange_rates ) > 0 ) {
			foreach ( $exchange_rates as $exchange_rates_value ) {
				if ( is_array( $exchange_rates_value ) || is_object( $exchange_rates_value ) && count( $exchange_rates_value ) > 0 ) {
					if ( is_array( $instance_wp_travel_currency_exchange_rates_symbols ) || is_object( $instance_wp_travel_currency_exchange_rates_symbols ) && count( $instance_wp_travel_currency_exchange_rates_symbols ) > 0 ) {
						$selected = in_array( 'display_all_rates', $instance_wp_travel_currency_exchange_rates_symbols ) ? 'selected' : '';
					}
					$symbols = "<option value='display_all_rates' {$selected}>All Currencies</option>";
					foreach ( $exchange_rates_value as $exchange_rates_symbol => $exchange_rates_amts ) {
						if ( is_array( $instance_wp_travel_currency_exchange_rates_symbols ) || is_object( $instance_wp_travel_currency_exchange_rates_symbols ) && count( $instance_wp_travel_currency_exchange_rates_symbols ) > 0 ) {
							$selected = in_array( $exchange_rates_symbol, $instance_wp_travel_currency_exchange_rates_symbols ) ? 'selected' : '';
						}
						$symbols .= "<option value='{$exchange_rates_symbol}' {$selected}>" . $get_currencies_array[ $exchange_rates_symbol ] . " ( {$exchange_rates_symbol} )</option>";
					}
				}
			}
		}
		?>

		<!-- title -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php esc_attr_e( 'Title:', 'wp-travel-pro' ); ?>
			</label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" required>
		</p>
		<!-- title -->
		<?php

		if ( isset( $subscription_error ) && $subscription_error ) {
			echo '<p class="description" style="color:red;">' . $subscription_error . '</p>';
		} else {
			if ( 'yes' === $is_premium ) { // Premius API Key.
				?>
				<!--Latest or Historical(Date) selection-->
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'wp_travel_currency_exchange_rates_select' ) ); ?>" style="display:none">
						<?php esc_attr_e( 'Display by:', 'wp-travel-pro' ); ?>
					</label>
					<select name=<?php echo $this->get_field_name( 'wp_travel_currency_exchange_rates_select' ); ?> id="wp_travel_currency_exchange_rates_select" onchange="fn_showHide_dateField( this );" style="display:none">
						<option <?php selected( isset( $instance['wp_travel_currency_exchange_rates_select'] ) ? $instance['wp_travel_currency_exchange_rates_select'] : '', 'latest' ); ?> value="latest">Latest</option>
						<option <?php selected( isset( $instance['wp_travel_currency_exchange_rates_select'] ) ? $instance['wp_travel_currency_exchange_rates_select'] : '', 'date' ); ?> value="date">Specific Date</option>
					</select>
					<?php
					if ( isset( $instance['wp_travel_currency_exchange_rates_select'] ) ) {
						$show = 'date' === $instance['wp_travel_currency_exchange_rates_select'] ? 'style="display:block"' : 'style="display:none"';
					}
					?>
					<!-- <input class="widefat wp_travel_currency_exchange_rates_select_date" id="<?php // echo esc_attr( $this->get_field_id( 'date_input' ) ); ?>" name="<?php // echo esc_attr( $this->get_field_name( 'date' ) ); ?>" type="date" value="<?php // echo esc_attr( $date ); ?>" max="<?php // echo date( 'Y-m-d' ); ?>" <?php // echo $show; ?> > -->
				</p>
				<!--Latest or Historical(Date) selection-->
				<!-- Currency/Symbols selection part -->
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'date' ) ); ?>">
						<?php esc_attr_e( 'Select Currency:', 'wp-travel-pro' ); ?>
					</label>
					<select name="<?php echo $this->get_field_name( 'wp_travel_currency_exchange_rates_symbols' ); ?>[]" id="wp_travel_currency_exchange_rates_symbols" multiple="multiple" >
						<?php echo $symbols; ?>
					</select>
				</p>
				<!-- Symbols selection part -->
				<?php

			} else {
				?>
				<!-- Currency/Symbols selection part -->
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'date' ) ); ?>">
						<?php esc_attr_e( 'Select Currency:', 'wp-travel-pro' ); ?>
					</label>
					<select name="<?php echo $this->get_field_name( 'wp_travel_currency_exchange_rates_symbols' ); ?>[]" id="wp_travel_currency_exchange_rates_symbols" class="wp_travel_currency_exchange_rates_symbols" multiple>
						<?php echo $symbols; ?>
					</select>
				</p>
				<!-- Symbols selection part -->
				<?php
			}
		}
		// section only for premium api keys if no [error][info] is set ends.
	}
	/**
	 * ==============================
	 * /Backend Display of widgets.
	 * ==============================
	 */

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['date']  = ( ! empty( $new_instance['date'] ) ) ? sanitize_text_field( $new_instance['date'] ) : '';
		$instance['wp_travel_currency_exchange_rates_select']  = ( ! empty( $new_instance['wp_travel_currency_exchange_rates_select'] ) ) ? ( $new_instance['wp_travel_currency_exchange_rates_select'] ) : '';
		$instance['wp_travel_currency_exchange_rates_symbols'] = ( ! empty( $new_instance['wp_travel_currency_exchange_rates_symbols'] ) ) ? ( $new_instance['wp_travel_currency_exchange_rates_symbols'] ) : '';

		return $instance;

	}

} // class WP_Travel_Currency_Exchange_Rate

/**
 * ===============================================
 * Register WP_Travel_Currency_Exchange_Rate widget.
 * ===============================================
 */
function register_WP_Travel_Currency_Exchange_Rate() {
	register_widget( 'WP_Travel_Currency_Exchange_Rate' );
}
add_action( 'widgets_init', 'register_WP_Travel_Currency_Exchange_Rate' );
