<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ====================================================
 * Function template for shortcode and widgets frontend.
 * ====================================================
 */
function wp_travel_currency_exchange_rates_frontend_templates( $selected_currencies ) {
	$transient_api_data   = wp_travel_currency_exchange_rates_transient_api_data( $selected_currencies );
	$exchange_date        = ! empty( $transient_api_data['date'] ) ? $transient_api_data['date'] : 'N/A';
	$base_currency        = ! empty( $transient_api_data['base'] ) ? $transient_api_data['base'] : 'N/A';
	$exchange_rates       = ! empty( $transient_api_data['rates'] ) ? $transient_api_data['rates'] : array();
	$get_currencies_array = wp_travel_currency_exchange_rates_currencies_name();
	ob_start();
	?>
	<div>
	<?php echo esc_html__( 'For date: ', 'wp-travel-pro' ); ?><?php echo esc_html( $exchange_date ); ?>
	</div>
	<div class="wptravel-currency-exchange-rates" >
		<table>
			<tbody>
				<tr>
					<td><?php echo esc_attr( $base_currency ); ?></td>
					<td><?php echo esc_html__( 'Currency Name', 'wp-travel-pro' ); ?></td>
					<td><?php echo esc_html__( 'Currency Code', 'wp-travel-pro' ); ?></td>
					<td><?php echo esc_html__( 'Exchange Rate', 'wp-travel-pro' ); ?></td>
				</tr>
				<?php
				if ( is_array( $exchange_rates ) || is_object( $exchange_rates ) && count( $exchange_rates ) > 0 ) {
					foreach ( $exchange_rates as $exchange_symbol => $exchange_amt ) {
						$exchange_symbols    = $exchange_symbol;
						$exchange_amts       = $exchange_amt;
						$get_currencies_name = ! empty( isset( $get_currencies_array[ $exchange_symbols ] ) ) ? $get_currencies_array[ $exchange_symbols ] : '';
						?>
						<tr>
							<td><?php echo esc_html__( '1', 'wp-travel-pro' ); ?></td>
							<td><?php echo esc_html( $get_currencies_name, 'wp-travel-pro' ); ?></td>
							<td><?php echo esc_html( $exchange_symbols ); ?></td>
							<td><?php echo esc_html( $exchange_amts ); ?></td>
						</tr>
						<?php
					}
				}
				?>
			</tbody>
		</table>
	</div>
	<?php
	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}




/**
 * ======================================================
 * This function is template for base currency selection.
 * ======================================================
 */
// function wp_travel_currency_exchange_rates_templates_select_base_currency( $base_currency_args ) {
// $base_curr_value             = '';
// $settings                    = wptravel_get_settings();
// $api_access_key_value        = isset( $settings['exchange_rate_api_key'] ) ? $settings['exchange_rate_api_key'] : '';
// $selected_base_currency      = '';
// $url                         = file_get_contents( "http://data.fixer.io/api/latest?access_key=" . $api_access_key_value . "&format=1" );
// $exchange                    = json_decode($url);
// $exchange                    = $exchange->rates;
// $default_base_currency_value = $exchange->EUR; // Default base currency.
// $new_base_currency_value     = $exchange->INR; // User selected currency.
// $base_exchange               = $default_base_currency_value / $new_base_currency_value;

// foreach( $exchange as $base_curr_symbol => $value ) {
// $new_exchange_rates[ $base_curr_symbol ] = ( $value * $base_exchange );
// $base_curr_value .= $new_exchange_rates[ $base_curr_symbol ];
// }
// }

