<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ===========================
 * Add default settings field.
 *
 * @param array $fields
 * @return array $fields
 * ===========================
 */
function wp_travel_exchange_rate_settings_fields( $fields ) {
	$exchange_rate_api_key                            = isset( $fields['exchange_rate_api_key'] ) && '' !== $fields['exchange_rate_api_key'] ? $fields['exchange_rate_api_key'] : '';
	$exchange_rate_api_key_premium_checkbox           = isset( $fields['exchange_rate_api_key_premium_checkbox'] ) && '' !== $fields['exchange_rate_api_key_premium_checkbox'] ? $fields['exchange_rate_api_key_premium_checkbox'] : '';
	$fields['exchange_rate_api_key']                  = $exchange_rate_api_key;
	$fields['exchange_rate_api_key_premium_checkbox'] = $exchange_rate_api_key_premium_checkbox;
	$fields['use_api_layer_fixer_api']                = 'no'; // @since wp travel 5.2.3
	return $fields;
}
add_filter( 'wp_travel_settings_fields', 'wp_travel_exchange_rate_settings_fields' );

/**
 * ===========================
 * Add default settings field.
 *
 * @param array $fields
 * @return array $fields
 * ===========================
 */
function wp_travel_exchange_rate_settings_fields_timer_reset( $fields ) {
	$set_api_timer_reset           = isset( $fields['set_api_timer_reset'] ) && '' !== $fields['set_api_timer_reset'] ? $fields['set_api_timer_reset'] : '24';
	$fields['set_api_timer_reset'] = $set_api_timer_reset;
	return $fields;
}
add_filter( 'wp_travel_settings_fields', 'wp_travel_exchange_rate_settings_fields_timer_reset' );


add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_exchange_rate_save_settings_v4', 12, 2 );

/**
 * Save setting v4.
 *
 * @param array $settings Settings list.
 * @param array $settings_data Settings data list.
 */
function wp_travel_exchange_rate_save_settings_v4( $settings, $settings_data ) {
	$api_key = isset( $settings_data['exchange_rate_api_key'] ) && ! empty( $settings_data['exchange_rate_api_key'] ) ? ( $settings_data['exchange_rate_api_key'] ) : '';
	$premium = isset( $settings_data['exchange_rate_api_key_premium_checkbox'] ) && ! empty( $settings_data['exchange_rate_api_key_premium_checkbox'] ) ? ( $settings_data['exchange_rate_api_key_premium_checkbox'] ) : '';
	$timer   = isset( $settings_data['set_api_timer_reset'] ) && ! empty( $settings_data['set_api_timer_reset'] ) ? ( $settings_data['set_api_timer_reset'] ) : '';

	$settings['exchange_rate_api_key']                  = $api_key;
	$settings['exchange_rate_api_key_premium_checkbox'] = $premium;
	$settings['set_api_timer_reset']                    = $timer;

	return $settings;
}

/**
 * ============================================================
 * This function run on button click "Purge" to purge transient.
 * ============================================================
 */
function wp_travel_exchange_settings_transient_purge_btn() {

	if ( isset( $_POST['btn_purge_api_cache'] ) ) {
		wp_travel_currency_exchange_rates_templates_delete_transient();
	}

	// Added for v4 settings.
	if ( wp_doing_ajax() ) {
		$post    = json_decode( file_get_contents( 'php://input' ), true );
		$post_id = ! empty( $post['purge_id'] ) ? ( $post['purge_id'] ) : '';
		if ( 'btn_purge_api_cache' === $post_id ) {
			wp_travel_currency_exchange_rates_templates_delete_transient();
		}
	}
}
add_action( 'admin_init', 'wp_travel_exchange_settings_transient_purge_btn' );
add_action( 'wp_ajax_wp_travel_exchange_settings_transient_purge_btn', 'wp_travel_exchange_settings_transient_purge_btn' );
