<?php
/**
 * @package wp-travel-conditional-payment
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Conditional_Payment_Core' ) ) :
	/**
	 * Mian class for download core
	 */
	class WP_Travel_Conditional_Payment_Core {
		protected static $ABSPATH;

		// protected static $PLUGIN_FILE;

		// protected static $VERSION;

			/**
			 * The single instance of the class.
			 *
			 * @var WP Travel Field Editor Core
			 * @since 1.0.0
			 */
		protected static $_instance = null;

		/**
		 * Main WP_Travel_Conditional_Payment_Core Instance.
		 * Ensures only one instance of WP_Travel_Conditional_Payment_Core is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 * @static
		 * @see WP_Travel_Conditional_Payment_Core()
		 * @return WP_Travel_Conditional_Payment_Core - Main instance.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Init core.
		 */
		public static function init( $plugin ) {
			self::$ABSPATH     = dirname( __FILE__ ) . '/';
			// self::$PLUGIN_FILE = __FILE__;
			// self::$VERSION     = $plugin['version'];

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$enable_downloads = isset( $settings['show_wp_travel_conditional_payment'] ) ? $settings['show_wp_travel_conditional_payment'] : 'yes';

			add_filter( 'wp_travel_settings_fields', array( 'WP_Travel_Conditional_Payment_Core', 'settings_fields' ) );
			add_action( 'wp_travel_addons_setings_tab_fields', array( 'WP_Travel_Conditional_Payment_Core', 'plugin_action' ) );
			add_action( 'admin_enqueue_scripts', array( 'WP_Travel_Conditional_Payment_Core', 'wp_travel_conditional_payment_enqueue_styles_admin' ) );

		}

		/**
		 * Default settings fields.
		 *
		 * @param array $settings WP Travel Settings.
		 * @return array
		 */
		public static function settings_fields( $settings ) {
			$settings['enable_conditional_payment']  	= 'no';
			$settings['enable_CP_by_billing_address']  	= 'yes';
			$settings['conditional_payment_list']   	= array();
	
			return $settings;
		}

		/**
		 * Plugin action to show / hide plugin settings and features.
		 */
		public static function plugin_action() {
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$field_name  = 'show_wp_travel_conditional_payment';
			$field_label = __( 'WP Travel Conditional Payment', 'wp-travel-pro' );

			$field_value = isset( $settings[ $field_name ] ) ? $settings[ $field_name ] : 'yes'; ?>
			<table class="form-table">
				<tr>
					<th>
						<label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html( $field_label ); ?></label>
					</th>
					<td>
						<span class="show-in-frontend checkbox-default-design">
							<label data-on="ON" data-off="OFF">
								<input value="no" name="<?php echo esc_attr( $field_name ); ?>" type="hidden" />
								<input <?php checked( $field_value, 'yes' ); ?> value="yes" name="<?php echo esc_attr( $field_name ); ?>" id="<?php echo esc_attr( $field_name ); ?>" type="checkbox" />
								<span class="switch"></span>
							</label>
						</span>
						<p class="description"><label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html__( 'Show all your "', 'wp-travel-pro' ) . esc_html( $field_label ) . esc_html__( '" settings and enable its feature.', 'wp-travel-pro' ); ?></label></p>
					</td>
				</tr>
			</table>
			<?php

		}

		/**
		 * Enqueue style and scripts for admin panel.
		 */
		public static function wp_travel_conditional_payment_enqueue_styles_admin() {
			global $current_screen;
			$screen            = get_current_screen();
			$current_post_type = ! empty( $current_screen->post_type ) ? $current_screen->post_type : '';

			if ( 'itinerary-booking_page_settings' !== $screen->id ) {
				return;
			}

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$enable_downloads = isset( $settings['show_wp_travel_conditional_payment'] ) ? $settings['show_wp_travel_conditional_payment'] : 'yes';
			
			wp_enqueue_script( 'wp-element' );
			wp_enqueue_script( 'wp-data' );


			$country_list = wptravel_get_countries();

			global $wpdb;

			$table_name = $wpdb->prefix . 'term_taxonomy';

			$field_name = 'term_taxonomy_id';

			$post_type = 'travel_locations';

			$prepared_statement = $wpdb->prepare( "SELECT {$field_name} FROM {$table_name} WHERE  taxonomy = %s", $post_type );
			$posts = $wpdb->get_col( $prepared_statement );

			$trip_location = array();
			foreach( $posts as $value ){

				$table_name = $wpdb->prefix . 'terms';

				$field_name = 'name';

				$prepared_statement = $wpdb->prepare( "SELECT {$field_name} FROM {$table_name} WHERE  term_id = %s", $value );
				$posts = $wpdb->get_col( $prepared_statement );
			
				$trip_location[str_replace( ' ', '-', strtolower($posts[0]) )] = $posts[0]; 
			}


			
			$deps = include_once sprintf( '%sapp/build/settings.asset.php', self::$ABSPATH );
			wp_enqueue_script( 'wp-travel-conditional-payment-settings', plugin_dir_url( __FILE__ ) . '/app/build/settings.js', $deps['dependencies'], $deps['version'], true );
			wp_localize_script( 'wp-travel-conditional-payment-settings', '_wp_travel_country_list', $country_list );
			wp_localize_script( 'wp-travel-conditional-payment-settings', '_wp_travel_trip_location_list', $trip_location );

			
		}
	}

endif;



