<?php
/**
 * Functions.
 *
 * @package wp-travel-authorize-net-checkout-core/inc/
 * @since 1.0.2
 */

require __DIR__ . '/authorizenet/autoload.php';

use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;
use net\authorize\util\ANetSensitiveFields;

add_action( 'wp_ajax_wp_travel_authorize_net', 'wp_travel_authorize_net_payment_ajax' );
add_action( 'wp_ajax_nopriv_wp_travel_authorize_net', 'wp_travel_authorize_net_payment_ajax' );

add_action( 'wp_ajax_wp_travel_authorize_net_new', 'wp_travel_authorize_net_payment_ajax_new' );
add_action( 'wp_ajax_nopriv_wp_travel_authorize_net_new', 'wp_travel_authorize_net_payment_ajax_new' );
/**
 * Gets Payment token for Further Processing
 *
 * @since 1.0.2
 */
function wp_travel_authorize_net_payment_ajax() {
	$postdata = $_POST;
	$formdata = $postdata['formData'];
	$amount   = $postdata['amount'];

	$authorizenet_vars = $postdata['authorizenetVars'];

	parse_str( $formdata, $form );

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$login_id        = isset( $settings['wp_travel_authorizenet_api_login_id'] ) ? $settings['wp_travel_authorizenet_api_login_id'] : '';
	$transaction_key = isset( $settings['wp_travel_authorizenet_transaction_key'] ) ? $settings['wp_travel_authorizenet_transaction_key'] : '';

	$merchant_authentication = new AnetAPI\MerchantAuthenticationType();
	$merchant_authentication->setName( $login_id );
	$merchant_authentication->setTransactionKey( $transaction_key );

	$refid = 'ref' . time();

	// create a transaction
	$transaction_request_type = new AnetAPI\TransactionRequestType();
	$transaction_request_type->setTransactionType( 'authCaptureTransaction' );
	$transaction_request_type->setAmount( $amount );

	// Set Hosted Form options
	$setting1 = new AnetAPI\SettingType();
	$setting1->setSettingName( 'hostedPaymentButtonOptions' );
	$setting1->setSettingValue( '{"text": "Pay"}' );

	$setting2 = new AnetAPI\SettingType();
	$setting2->setSettingName( 'hostedPaymentOrderOptions' );
	$setting2->setSettingValue( '{"show": true}' );

	$home       = home_url( '/' );
	$cancel_url = add_query_arg(
		array(
			'resultCode' => 'failed',
			'booked'     => false,
		),
		$home
	);
	$url        = add_query_arg(
		array(
			'resultCode' => 'OK',
		),
		$home
	);

	$setting3 = new AnetAPI\SettingType();
	$setting3->setSettingName( 'hostedPaymentReturnOptions' );
	$setting3->setSettingValue(
		'{ "showReceipt": false, "cancelUrl":"' . $cancel_url . '", "url":"' . $url . '"}'
	);

	$communicator_url = $authorizenet_vars['communicatorUrl'];
	$setting4         = new AnetAPI\SettingType();
	$setting4->setSettingName( 'hostedPaymentIFrameCommunicatorUrl' );
	$setting4->setSettingValue(
		"{\"url\": \"{$communicator_url}\"}"
	);

	// Build transaction request.
	$request = new AnetAPI\GetHostedPaymentPageRequest();
	$request->setMerchantAuthentication( $merchant_authentication );
	$request->setRefId( $refid );
	$request->setTransactionRequest( $transaction_request_type );

	$request->addToHostedPaymentSettings( $setting1 );
	$request->addToHostedPaymentSettings( $setting2 );
	$request->addToHostedPaymentSettings( $setting3 );
	$request->addToHostedPaymentSettings( $setting4 );

	// Execute request.
	$controller = new AnetController\GetHostedPaymentPageController( $request );
	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	$api      = $test_mode ? \net\authorize\api\constants\ANetEnvironment::SANDBOX : \net\authorize\api\constants\ANetEnvironment::PRODUCTION;
	$response = $controller->executeWithApiResponse( $api );

	if ( ( $response != null ) && ( 'Ok' === $response->getMessages()->getResultCode() ) ) {
		wp_send_json_success( array( 'token' => $response->getToken() ) );
	} else {
		$error = $response->getMessages()->getMessage();
		wp_send_json_error( array( 'Error' => $error ) );
	}
	die;

}

add_action( 'wp_ajax_wp_travel_currency_verification', 'wp_travel_currency_verification_payment_ajax' );
/**
 * Verify Currency.
 *
 * @since 1.0.2
 */
function wp_travel_currency_verification_payment_ajax() {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$login_id        = isset( $settings['wp_travel_authorizenet_api_login_id'] ) ? $settings['wp_travel_authorizenet_api_login_id'] : '';
	$transaction_key = isset( $settings['wp_travel_authorizenet_transaction_key'] ) ? $settings['wp_travel_authorizenet_transaction_key'] : '';

	/*
	 * Create a merchantAuthenticationType object with authentication details.
	 * retrieved from the constants file.
	 */
	$merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
	$merchantAuthentication->setName( $login_id );
	$merchantAuthentication->setTransactionKey( $transaction_key );

	// Set the transaction's refId
	$refId = 'ref' . time();

	$request = new AnetAPI\GetMerchantDetailsRequest();
	$request->setMerchantAuthentication( $merchantAuthentication );

	$controller = new AnetController\GetMerchantDetailsController( $request );

	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	$api      = $test_mode ? \net\authorize\api\constants\ANetEnvironment::SANDBOX : \net\authorize\api\constants\ANetEnvironment::PRODUCTION;
	$response = $controller->executeWithApiResponse( $api );

	if ( ( $response != null ) && ( $response->getMessages()->getResultCode() == 'Ok' ) ) {
		$currencies = array();
		foreach ( $response->getCurrencies() as $currency ) {
			$currencies[] = $currency;
		}
		wp_send_json_success( array( 'currencies' => $currencies ) );
	} else {
		$error = $response->getMessages()->getMessage();
		wp_send_json_error( array( 'Error' => $error ) );
	}
	die;
}

add_action( 'init', 'wp_travel_auhtorizenet_listen_ipn' );
/**
 * Listen for a $_GET request from our PayPal IPN.
 * This would also do the "set-up" for an "alternate purchase verification"
 */
function wp_travel_auhtorizenet_listen_ipn() {
	if ( isset( $_GET['anet'] )
		&& $_GET['anet'] == 'IPN'
		|| isset( $_GET['test'] )
		&& $_GET['test'] == true ) {
	}
}
