<?php
/**
 * Settings class
 */


/**
 * WP_Travel_Advanced_Gallery_Settings.
 */
class WP_Travel_Advanced_Gallery_Settings {

	/**
	 * Default Settings.
	 *
	 * @var array
	 */
	private $default_settings;

	protected static $_instance = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		self::$_instance        = $this;
		add_filter( 'wp_travel_settings_fields', array( $this, 'default_settings' ) );
	}

	/**
	 * Gallery Settings.
	 *
	 * @return void
	 */
	
	public function get_gallery_settings() {
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		return $settings['wp_travel_advanced_gallery_settings'];
	}

	public function default_settings( $settings_fields ) {
		$settings_fields['wp_travel_advanced_gallery_settings'] = array(
			'enable'           => 'no',
			'layout'           => 'grid',
			'number_of_slides' => 4,
			'autoplay'         => false,
			'dots'	=> false,
			'arrows'	=> true,
		);
		return $settings_fields;
	}
}

new WP_Travel_Advanced_Gallery_Settings();