jQuery(function ($) {
    var $document = $(document);
    var container = $('.wptag__items-list') // gallery items holder

    // Serialize Form JSON
    var serializeFormJSON = function (fields) {
        var o = {};
        var a = fields.serializeArray();
        $.each(a, function () {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };

    // Update Gallery Items.
    var updategallery = function (data) {
        var index = 0;
        $('.wptag__items-list li').each(function(i, el){
            var elIndex = el.dataset.index;
            if(parseInt(elIndex) > index){
                index = parseInt(elIndex);
            }
        });
        var template = wp.template('wp-travel-advanced-gallery-li');
        var newData = []
        data && Object.values(data).map(function (val) {
            index += 1;
            if (!val['index']) {
                val['index'] = index;
            }
            newData.push(val)
        })
        container.append(template(newData));
        return true
    }

    // Init uploader.
    var advGallery = $('.wptag__uploader-btn').wpTravelUploader({
        media_options: {
            multiple: true
        },
        onSelect: function (mediaUploader) {
            attachments = mediaUploader.state().get('selection').toJSON();
            updategallery(attachments);
        }
    });

    // Edit on click.
    $document.on('click', '.wptag__edit-thumb', function (e) {
        e.preventDefault()
        var $this = $(this)
        var mediaUploader;
        mediaUploader = wp.media({
            multiple: false,
        })
        .on('select', function () {
            var attachment = mediaUploader.state().get('selection').toJSON();
            $this.parent('.wptag__thumbnail').find('img').attr('src', attachment[0].sizes.thumbnail.url).show().prev('.media-default-thumbnail').hide()
            $('#wptag__thumb-url-' + $this.parents('li').data('index')).val(attachment[0].sizes.thumbnail.url)
            $('#wptag__attachmentid-' + $this.parents('li').data('index')).val(attachment[0].id)
        })
        .open();
    })

    // Remove item from list.
    $document.on('click', '.wptag__card-remove', function (e) {
        $this = $(this)
        e.preventDefault();
        confirm('Are you sure you want to remove?') && $this.parents('li').remove();
    })

    // Add External link form button.
    // $('.wptag__add-external-link-btn').on('click', function () {
    //     var template = wp.template('wptag-external-link-form-template');
    //     $('.wptag__external-link-form-wrapper').html(template())
    // });
    var getexternalLinkFormHtml = function(){
        var template = wp.template('wptag-external-link-form-template');
        return template();
        // $('.wptag__external-link-form-wrapper').html(template())

    }
    $('.wptag__add-external-link-btn').magnificPopup({
        items: {
            src: getexternalLinkFormHtml(),
            type: 'inline'
        }
    });

    var prepareDataByLink = function (url, data) {
        var group = parseUrl(url)
        if (group && group[0].match(/youtube|youtu.be/)) {
            data['source'] = 'youtube',
                data['url'] = 'https://www.youtube.com/embed/' + group[1]
            data['id'] = group[1]
            data['type'] = 'external'
            data['thumb_url'] = 'https://i.ytimg.com/vi_webp/' + group[1] + '/hqdefault.webp'
        } else if (group && group[0].match(/vimeo/)) {
            data['source'] = 'vimeo',
            data['url'] = 'https://player.vimeo.com/video/' + group[4]
            data['id'] = group[4]
            data['type'] = 'external'
            data['thumb_url'] = ''
        } else {
            data = null
        }
        return data
    }

    var parseUrl = function (url) {
        var group = url && url.match(/youtube|youtu.be/) && url.match(/(?:(?:https?:)?\/\/)?(?:www\.)?youtu(?:be\.com\/(?:watch\?(?:.*?&(?:amp;)?)*v=|v\/|embed\/)|\.be\/)([\w‌​\-]+)(?:(?:&(?:amp;)?|\?)[\w\?=]*)*/) || url.match(/vimeo/) && url.match(/(http|https)?:\/\/(www\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|)(\d+)(?:|\/\?)/)
        return group
    }

    // Add External Video to list.
    $document.on('click', '.wptag__add-external-media', function (e) {
        e.preventDefault();
        var $this = $(this), values = [], data = {};
        var fields = $this.parent().find('input, textarea');
        fields = serializeFormJSON(fields)
        fields && Object.keys(fields).map(function (i) {
            data[i] = fields[i]
        })
        var linkField = $this.siblings('input[name=url]')
        var link = linkField.val()
        data = prepareDataByLink(link, data);
        data && values.push(data) && updategallery(values) && $this.parent('.wptag__external-link-form')
            .fadeOut(400, function () {
                $(this).remove();
            }) && $.magnificPopup.close() || linkField.css('border', '1px solid #f00')
    })

    // Cancel the external Video.
    $document.on('click', '.wptag__cancel-external-media', function (e) {
        e.preventDefault();
        $.magnificPopup.close();
        $(this).parent('.wptag__external-link-form').fadeOut('400', function () {
            $(this).remove();
        })
    });

    // embed video preview.
    $document.on('keyup change', '.wptag__external-link-form input[name=url]', function () {
        var url = this.value;
        var parts = url.match(/(?:(?:https?:)?\/\/)?(?:www\.)?youtu(?:be\.com\/(?:watch\?(?:.*?&(?:amp;)?)*v=|v\/|embed\/)|\.be\/)([\w‌​\-]+)(?:(?:&(?:amp;)?|\?)[\w\?=]*)*/)
        if (parts) {
            $('.wptag__embed-preview').html('<iframe width="300" height="200" src="https://www.youtube.com/embed/' + parts[1] + '"></iframe>')
        }
        parts = url.match(/(http|https)?:\/\/(www\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|)(\d+)(?:|\/\?)/)
        if (parts) {
            $('.wptag__embed-preview').html('<iframe width="300" height="200" src="https://player.vimeo.com/video/' + parts[4] + '?portrait=0"></iframe>')
        }
    })

    var setFeatureImage = function (id, current) {
        if(current && $('#wptag__thumbnail_id').val().length > 0 && $('#wptag__thumbnail_id').val() != '0') {
            return;
        }
        if(typeof id == 'undefined' || id == '0') {
            var items = $('.wptag__items-list li')
            var featureImage = document.querySelector('.wptag__thumbnail img[data-type=image]');
            id = $(featureImage).parents('li').data('attachmentid');
            id && featureImage.closest('li').classList.add('wptag__featured-image');
        }
        $('#wptag__thumbnail_id').val(id);
    }

    // Make featured image on click.
    $document.on('click', '.wptag__thumbnail img[data-type=image]', function () {
        $this = $(this);
        $this.parents('li').addClass('wptag__featured-image').siblings().removeClass('wptag__featured-image')
        var attachmentid = $this.parents('li').data('attachmentid')
        setFeatureImage(attachmentid)
    });

    container.sortable({
        handle: '.wptag__dragger',
        update: function (e, ui) {
            $(this).children('li').each(function (index, value) {
                $('#wptag__index-' + $(this).data('index')).val(index)
                // $(this).attr('data')
            })
        }
    })

    // List Gallery.
    var galleryData = wp_travel_drag_drop_uploader.gallery_data ? wp_travel_drag_drop_uploader.gallery_data : {};
    galleryData && updategallery(galleryData.items) && setFeatureImage(galleryData._thumbnail_id, true);

});


