jQuery(function ($) {
    var container = $('.wp-travel-advanced-gallery-items-list');
    var masonry, slider, popup;

    var initPopup = function () {
        popup = container.magnificPopup({
            delegate: 'a',
            gallery: {
                enabled: true
            },
            type: 'image', // this is default type
            image: {
                markup: '<div class="mfp-figure wptag"><button title="Close (Esc)" type="button" class="mfp-close">×</button>' +
                    '<figure><div class="mfp-image-wrap"><img class="mfp-img" /></div>' +
                    '<div class="mfp-bottom-bar">' +
                    '<div class="wptag-bottom-bar">' +
                    '<div class="mfp-info-wrap"><div class="mfp-title"></div>' +
                    '<div class="mfp-description"></div>' +
                    '<div class="mfp-caption"></div></div>' +
                    '<div class="mfp-counter"></div>' +
                    '</div>' +
                    '</div>' +
                    '</figure>' +
                    '</div>',
            },
            iframe: {
                markup: '<div class="mfp-iframe-scaler wptag">' +
                    '<div class="mfp-close"></div>' +
                    '<figure><div class="mfp-image-wrap"><iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe></div>' +
                    '<div class="mfp-bottom-bar">' +
                    '<div class="wptag-bottom-bar">' +
                    '<div class="mfp-info-wrap"><div class="mfp-title"></div>' +
                    '<div class="mfp-caption"></div></div>' +
                    '<div class="mfp-counter"></div>' +
                    '</div>' +
                    '</div>' +
                    '</figure>' +
                    '</div>',
                patterns: {
                    youtube: {
                        index: 'https://youtube.com/', // String that detects type of video (in this case YouTube). Simply via url.indexOf(index).
                        id: 'v=', // String that splits URL in a two parts, second part should be %id%
                        src: '%id%?autoplay=1&showinfo=0&controls=0&autohide=1' // URL that will be set as a source for iframe.
                    },
                }
            },
   
            callbacks: {
                markupParse: function (template, values, item) {
                    values.title = item.el.attr('title')
                    values.caption = item.el.data('caption')
                }
            },
            zoom: {
                enabled: true,
                duration: 300, // don't foget to change the duration also in CSS
                opener: function (element) {
                    return element.find('img');
                }
            }
        })
    }
    

    if( typeof wp_travel.gallery_data.settings.arrows === 'undefined'  ){
        wp_travel.gallery_data.settings.arrows = 1;
    }
    
    var initgallerySlider = function () {
        var noOfSlides = wp_travel.gallery_data.settings.number_of_slides && wp_travel.gallery_data.settings.number_of_slides > 0 ? wp_travel.gallery_data.settings.number_of_slides : 4
        var showArrow = wp_travel.gallery_data.settings.arrows == "1" ? true : false;
        var showDots = wp_travel.gallery_data.settings.dots == "1" ? true : false;

        slider = container.not('.slick-initialized').slick({
            dots: showDots,
            arrows: showArrow,
            infinite: true,
            speed: 300,
            slidesToShow: noOfSlides,
            adaptiveHeight: true,
            autoplay: wp_travel.gallery_data.settings.autoplay,
            responsive: [
                {
                    breakpoint: 993,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 4
                    }
                },{
                    breakpoint: 769,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 3
                    }
                }, {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 2
                    }
                }
            ]
        })
        return true;
    }

    var initMasonryGrid = function () {
        masonry = container.isotope({
            itemSelector: '.wp-travel-advanced-gallery-items-list-masonry .item',
            percentPosition: false,
        })
    }

    var viewInit = function() {
        wp_travel.gallery_data.settings.layout == 'slider' ? initgallerySlider() && initPopup() : initPopup()
        wp_travel.gallery_data.settings.layout == 'masonry' && !masonry && initMasonryGrid()
    }

    $('#gallery').prev('h2').on('click', viewInit);
    $('.wp-travel-ert.gallery').on('click', viewInit)
    if ( $( '.wp-travel-advanced-gallery-items-list:visible' ).length > 0 ) {
        viewInit();
    }

});
