<?php
/**
 * Class Module.
 *
 * @package inc/modules
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! class_exists( 'WP_Travel_Pro_Modules' ) ) :
	/**
	 * WP Travel Pro Modules.
	 */
	class WP_Travel_Pro_Modules {
		/**
		 * Modules.
		 *
		 * @var array
		 */
		private static $modules;

		/**
		 * Param.
		 *
		 * @var array
		 */
		private static $params;

		/**
		 * Settings.
		 *
		 * @var array
		 */
		private static $settings;

		/**
		 * Default settings.
		 *
		 * @var array
		 */
		private static $default_settings;

		/**
		 * Saved settings.
		 *
		 * @var array
		 */
		private static $saved_settings;

		/**
		 * WP Travel User Since.
		 *
		 * @var array
		 */
		private static $user_since;

		/**
		 * Init.
		 *
		 * @param array $params Param of module.
		 */
		public static function init( $params = array() ) {
			self::$modules = array(
				'wp-travel-pro' => array(
					'title'      => __( 'WP Travel Pro', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Pro_Core',
					'category'   => 'Pro',
				),
				'wp-travel-downloads' => array(
					'title'      => __( 'WP Travel Downloads', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Downloads_Core',
					'category'   => 'Pro',
				),
				'wp-travel-tour-guide' => array(
					'title'      => __( 'WP Travel Travel Guide', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Travel_Guide_Core',
					'category'   => 'Pro',
				),
				'wp-travel-conditional-payment' => array(
					'title'      => __( 'WP Travel Conditional Payment', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Conditional_Payment_Core',
					'category'   => 'Pro',
				),
				'wp-travel-custom-filters' => array(
					'title'      => __( 'WP Travel Custom Filters', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Custom_Filters_Core',
					'category'   => 'Pro',
				),
				'wp-travel-mailchimp' => array(
					'title'      => __( 'WP Travel Mailchimp', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Mailchimp_Core',
					'category'   => 'Pro',
				),
				'wp-travel-partial-payment' => array(
					'title'      => __( 'WP Travel Partial Payment', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Partial_Payment_Core',
					'category'   => 'Pro',
				),
				'wp-travel-paystack-checkout' => array(
					'title'      => __( 'WP Travel Paystack Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Paystack_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-khalti-checkout' => array(
					'title'      => __( 'WP Travel Khalti Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Khalti_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-field-editor' => array(
					'title'      => __( 'WP Travel Field Editor', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Field_Editor_Core',
					'category'   => 'Pro',
				),
				'wp-travel-tour-extras' => array(
					'title'      => __( 'WP Travel Trip Extra', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Tour_Extras_Core',
					'category'   => 'Pro',
				),
				'wp-travel-utilities' => array(
					'title'      => __( 'WP Travel Utilities', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Utilities_Core',
					'category'   => 'Pro',
				),
				'wp-travel-inventory-management' => array(
					'title'      => __( 'WP Travel Inventory Management', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Inventory_Management_Core',
					'category'   => 'Pro',
				),
				'wp-travel-razorpay-checkout' => array(
					'title'      => __( 'WP Travel Razorpay Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Razorpay_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-instamojo-checkout' => array(
					'title'      => __( 'WP Travel Instamojo Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Instamojo_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-stripe' => array(
					'title'      => __( 'WP Travel Stripe Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Stripe_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-paypal-express-checkout' => array(
					'title'      => __( 'WP Travel Paypal Express Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Paypal_Express_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-group-discount' => array(
					'title'      => __( 'WP Travel Group Discount', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Group_Discount_Core',
					'category'   => 'Pro',
				),
				'wp-travel-import-export' => array(
					'title'      => __( 'WP Travel Import Export', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Import_Export_Core',
					'category'   => 'Pro',
				),
				'wp-travel-wishlists' => array(
					'title'      => __( 'WP Travel Wishlists', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Wishlists_Core',
					'category'   => 'Pro',
				),
				'wp-travel-authorize-net-checkout' => array(
					'title'      => __( 'WP Travel Authorize.net Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Authorize_Net_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-currency-exchange-rates' => array(
					'title'      => __( 'WP Travel Currency Exchange Rates', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Currency_Exchange_Rates_Core',
					'category'   => 'Pro',
				),
				'wp-travel-here-map' => array(
					'title'      => __( 'WP Travel Here Map', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Here_Map_Core',
					'category'   => 'Map',
				),
				'wp-travel-payfast-checkout' => array(
					'title'      => __( 'WP Travel Payfast Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Payfast_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-payu-checkout' => array(
					'title'      => __( 'WP Travel PayU Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_PayU_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-payhere-checkout' => array(
					'title'      => __( 'WP Travel Payhere Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Payhere_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-advanced-gallery' => array(
					'title'      => __( 'WP Travel Advanced Gallery', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Advanced_Gallery_Core',
					'category'   => 'Pro',
				),
				'wp-travel-trip-weather-forecast' => array(
					'title'      => __( 'WP Travel Trip Weather Forecast', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Trip_Weather_Forecast_Core',
					'category'   => 'Pro',
				),
				'wp-travel-payu-latam-checkout' => array(
					'title'      => __( 'WP Travel PayU Latam Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_PayU_Latam_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-zapier' => array(
					'title'      => __( 'WP Travel Zapier', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Zapier_Core',
					'category'   => 'Pro',
				),
				'wp-travel-multiple-currency' => array(
					'title'      => __( 'WP Travel Multiple Currency', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Multiple_Currency_Core',
					'category'   => 'Pro',
				),
				'wp-travel-stripe-ideal-checkout' => array(
					'title'      => __( 'WP Travel Stripe iDEAL Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Stripe_Ideal_Checkout_Core',
					'category'   => 'Payment',
				),
				'wp-travel-invoice' => array(
					'title'      => __( 'WP Travel Invoice', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Invoice_Core',
					'category'   => 'Pro',
				),
				'wp-travel-google-calendar' => array(
					'title'      => __( 'WP Travel Google Calendar', 'wp-travel-pro' ),
					'core_class' => 'WpTravel_Google_Calendar_Core',
					'category'   => 'Pro',
				),
				'wp-travel-square-checkout' => array(
					'title'      => __( 'WP Travel Square Checkout', 'wp-travel-pro' ),
					'core_class' => 'WP_Travel_Squareup_Checkout_Core',
					'category'   => 'Payment',
				),
			);
			// Init param.
			self::$params = $params; // Need abspath and version in include file to check.

			add_action( 'init', function() {
				add_filter( 'wptravel_modules', array( 'WP_Travel_Pro_Modules', 'modules' ) );

				self::$settings         = wptravel_get_settings();
				self::$default_settings = wptravel_settings_default_fields();
				self::$user_since       = get_option( 'wp_travel_user_since', '3.0.0' );

				// Includes.
				self::includes();

			}, 0 );
			// init settings.
			self::$saved_settings   = get_option( 'wp_travel_settings', array() ); // To get only saved settings data.
		}

		/**
		 * Modules.
		 */
		public static function modules( $modules ) {
			if ( self::$modules ) {
				$settings         = self::$settings;
				$default_settings = self::$default_settings;
				$saved_settings   = self::$saved_settings;
				$default_modules  = isset( $default_settings['modules'] ) ? $default_settings['modules'] : array();
				$user_since       = self::$user_since;

				if( !$user_since ){
					$user_since = '7.0.0';
				}

				foreach ( self::$modules as $module_key => $module ) {
					$key         = 'show_' . str_replace( '-', '_', $module_key );
					$module_name = $key;

					// Enabled/disable module check.
					$enabled_module = false;

					if ( ! $saved_settings && version_compare( $user_since, '5.2.2', '>=' ) ) {
						$enabled_module = true; // By default enabled for new user from v 5.2.2.
					} elseif ( $saved_settings && isset( $saved_settings['modules'] ) && count( $saved_settings['modules'] ) > 0 ) { // check If data is saved in new array structure.
						$saved_settings['modules'][ 'show_wp_travel_conditional_payment' ]['value'] = 'yes';
						$enabled_module = 'yes' === $saved_settings['modules'][ $module_name ]['value']; // Saved modules values.
					} else {
						// fetch saved value from old structure. // Legacy.
						$enabled_module = isset( $settings[ $module_name ] ) && 'yes' === $settings[ $module_name ]; // Saved modules values.

						// Exceptional cases.
						switch ( $module_name ) {
							case 'show_wp_travel_inventory_management':
								$enabled_module = isset( $settings['show_wp_travel_inventory_magagement'] ) && 'yes' === $settings['show_wp_travel_inventory_magagement']; // Typo error in old addons settings key.
								break;

							// Previously have no settings to enabled disbled for [partial payment, Trip weather, Zapier].
							case 'show_wp_travel_partial_payment':
							// case 'show_wp_travel_trip_weather_forecast':
							// case 'show_wp_travel_zapier':
								$enabled_module = true;
								break;
							case 'show_wp_travel_invoice':
								$enabled_module = isset( $settings['enable_invoice'] ) && 'yes' === $settings['enable_invoice'];
								break;

							// Payment addons. [Note: Bank deposite and standard paypal is not addons ].
							case 'show_wp_travel_authorize_net_checkout':
								$enabled_module = isset( $settings['payment_option_authorizenet'] ) && 'yes' === $settings['payment_option_authorizenet'];
								break;
							case 'show_wp_travel_paypal_express_checkout':
								$enabled_module = isset( $settings['payment_option_express_checkout'] ) && 'yes' === $settings['payment_option_express_checkout'];
								break;
							case 'show_wp_travel_khalti_checkout':
								$enabled_module = isset( $settings['payment_option_khalti'] ) && 'yes' === $settings['payment_option_khalti'];
								break;
							case 'show_wp_travel_payfast_checkout':
								$enabled_module = isset( $settings['payment_option_payfast'] ) && 'yes' === $settings['payment_option_payfast'];
								break;
							case 'show_wp_travel_payhere_checkout':
								$enabled_module = isset( $settings['payment_option_payhere'] ) && 'yes' === $settings['payment_option_payhere'];
								break;

							case 'show_wp_travel_paystack_checkout':
								$enabled_module = isset( $settings['payment_option_paystack'] ) && 'yes' === $settings['payment_option_paystack'];
								break;
							case 'show_wp_travel_payu_checkout':
								$enabled_module = isset( $settings['payment_option_payu'] ) && 'yes' === $settings['payment_option_payu'];
								break;
							case 'show_wp_travel_razorpay_checkout':
								$enabled_module = isset( $settings['payment_option_razorpay_checkout'] ) && 'yes' === $settings['payment_option_razorpay_checkout'];
								break;
							case 'show_wp_travel_square_checkout':
								$enabled_module = isset( $settings['payment_option_squareup_checkout'] ) && 'yes' === $settings['payment_option_squareup_checkout'];
								break;
							case 'show_wp_travel_stripe':
								$enabled_module = isset( $settings['payment_option_stripe'] ) && 'yes' === $settings['payment_option_stripe'];
								break;
							case 'show_wp_travel_stripe_ideal_checkout':
								$enabled_module = isset( $settings['payment_option_stripe_ideal'] ) && 'yes' === $settings['payment_option_stripe_ideal'];
								break;
							case 'show_wp_travel_instamojo_checkout':
								$enabled_module = isset( $settings['payment_option_instamojo_checkout'] ) && 'yes' === $settings['payment_option_instamojo_checkout'];
								break;
							case 'show_wp_travel_payu_latam_checkout':
								$enabled_module = isset( $settings['payment_option_payu_latam'] ) && 'yes' === $settings['payment_option_payu_latam'];
								break;
						}
					}
					$module['value'] = $enabled_module ? 'yes' : 'no'; // just to indicate enable / disable.

					$module['force_enable'] = false;
					if ( 'wp-travel-pro' == $module_key ) {
						$module['force_enable'] = true; // Force enabled for wp travel pro module. Pro module consists all notices so need to enable it.
					}
					$modules[ $key ] = $module;
				}
			}
			$columns = array_column( $modules, 'title' );
			array_multisort( $columns, SORT_ASC, $modules );
			return $modules;
		}

		/**
		 * WP_Travel_Pro includes.
		 */
		public static function includes() {
			$settings         = wptravel_get_settings(); // Need to re assign instead of using self::$settings to get updated data.
			$default_settings = wptravel_settings_default_fields(); // Need to re assign instead of using self::$default_settings to get updated data.
			$default_modules  = isset( $default_settings['modules'] ) ? $default_settings['modules'] : array();
			$modules          = isset( $settings['modules'] ) && count( $settings['modules'] ) > 0 ? $settings['modules'] : $default_modules;
			$saved_settings   = get_option( 'wp_travel_settings', array() );
			if ( is_array( $default_modules ) && count( $default_modules ) > 0 ) {
				foreach ( $default_modules as $key => $module ) {
					$module_name      = $key;
					$main_folder_key  = str_replace( '_', '-', $module_name );
					$main_folder_key  = str_replace( 'show-', '', $main_folder_key );
					$main_folder      = str_replace( 'wp-travel-', '', $main_folder_key ) . '-core';
					$module_core_file = sprintf( '%sinc/modules/%s/%s-core.php', WP_TRAVEL_PRO_ABSPATH, $main_folder, $main_folder_key );

					$enabled_module = isset( $modules[ $module_name ] ) && 'yes' === $modules[ $module_name ]['value'];
					$forced_enabled = isset( $modules[ $module_name ] ) && $modules[ $module_name ]['force_enable'];

					if ( file_exists( $module_core_file ) && ! class_exists( $module['core_class'] ) && ( $enabled_module || $forced_enabled ) ) {
						include_once $module_core_file;
						$module['core_class']::init( self::$params );
					}
				}
			} else {
				foreach ( self::$modules as $key => $module ) {
					$main_folder      = str_replace( 'wp-travel-', '', $key ) . '-core';
					$module_core_file = sprintf( '%sinc/modules/%s/%s-core.php', WP_TRAVEL_PRO_ABSPATH, $main_folder, $key );
					if ( file_exists( $module_core_file ) && ! class_exists( $module['core_class'] ) ) {
						include_once $module_core_file;
						$module['core_class']::init( self::$params );
					}
				}
			}
		}
	}

	$params = array(
		'abspath'     => WP_TRAVEL_PRO_ABSPATH,
		'plugin_file' => WP_TRAVEL_PRO_PLUGIN_FILE,
		'version'     => WP_TRAVEL_PRO_VERSION,
	);
	WP_Travel_Pro_Modules::init( $params );
endif;
