<?php
get_header();
echo '<div class="wrap wp-travel-card"><h2>Détail de l’hôtel</h2>';

$hotel_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$hotel_id) {
    echo "<div class='notice'>❌ Identifiant d'hôtel manquant ou invalide.</div>";
    get_footer(); exit;
}

$login = get_option('mygo_login');
$password = get_option('mygo_password');

$response = wp_remote_post('https://admin.mygo.co/api/hotel/HotelDetail', array(
    'body' => json_encode(['Credential' => ['Login' => $login, 'Password' => $password], 'Id' => $hotel_id]),
    'headers' => ['Content-Type' => 'application/json'],
    'timeout' => 15,
));

if (is_wp_error($response)) {
    echo "<div class='notice'>❌ Erreur lors de l'appel API : " . esc_html($response->get_error_message()) . "</div>";
    get_footer(); exit;
}

$data = json_decode(wp_remote_retrieve_body($response), true);
if (empty($data['HotelDetail'])) {
    echo "<div class='notice'>⚠️ Aucun détail trouvé pour cet hôtel (ID: $hotel_id).</div>";
    echo "<pre>Réponse brute : " . htmlentities(wp_remote_retrieve_body($response)) . "</pre>";
    get_footer(); exit;
}

$hotel = $data['HotelDetail'];
echo '<div class="wp-travel-package">';
echo '<div class="wp-travel-package-thumb"><img src="' . esc_url($hotel['Image']) . '" alt="' . esc_attr($hotel['Name']) . '" /></div>';
echo '<div class="wp-travel-package-content">';
echo '<h3>' . esc_html($hotel['Name']) . '</h3>';
echo '<p><strong>Ville :</strong> ' . esc_html($hotel['City']['Name']) . '</p>';
echo '<p><strong>Adresse :</strong> ' . esc_html($hotel['Adress']) . '</p>';
echo '<p>' . wp_kses_post($hotel['LongDescription']) . '</p>';
echo '<a href="' . esc_url(site_url('/reservation/?hotel=' . $hotel['Id'])) . '" class="wp-travel-btn">Demander un devis</a>';
echo '</div></div>';

if (!empty($hotel['Album'])) {
    echo '<div class="wp-travel-gallery" style="display:flex; gap:10px; margin-top:20px;">';
    foreach ($hotel['Album'] as $img) {
        echo '<div><img src="' . esc_url($img['Url']) . '" style="width:150px;border-radius:5px;" /></div>';
    }
    echo '</div>';
}

get_footer();
?>
